// The app shows a clock when fullscreen and time as text when minimized in homescreen
import QtQuick 1.1
import Sailfish.Silica 1.0

ApplicationWindow{
    id: clockWindow

    // time is stored here
    property variant date: new Date()

    // Timer updates the time every 1000ms
    Timer {
        running: true; interval: 1000; repeat: true;
        onTriggered: date = new Date
    }
    Column {
        anchors.fill: parent

        // Header with text to top of the page
        PageHeader {
            title: "Clock"
        }

        // The clock
        Item {
            id: clockBackground

            // Padding on both sides
            width: clockWindow.width - theme.paddingLarge * 2
            height: width

            // centered horizonally
            anchors.horizontalCenter: parent.horizontalCenter

            // Backgroung circle
            Rectangle {
                anchors.fill: parent

                // rounded corner, if rectange is a square then defining
                // radius: width/2 the rectangle becomes circle
                radius: width/2
                opacity: 0.2
                color: "white"
            }

            // minutes indicator
            Rectangle {
                x: clockBackground.width / 2
                y: x
                height: x
                width: 8
                color: "black"

                // every time date is updated this value is recalculated
                rotation: (date.getMinutes() + 30) * 6
                transformOrigin: Item.Top
            }

            // hours indicator
            Rectangle {
                x: clockBackground.width / 2
                y: x
                width: 12
                height: 0.8 * x
                rotation: (date.getHours() / 24 * 360) + 60
                transformOrigin: Item.Top
                color: "black"
            }

            // seconds indicator
            Rectangle {
                x: clockBackground.width / 2
                y: x
                height: x
                width: 3
                color: theme.highlightColor
                radius: width / 2
                transformOrigin: Item.Top
                rotation: date.getSeconds() * 6
            }
        }
    }

    // When user is using the homeview cover is shown to represent the app.
    // This cover just shows the time as text like "11:30"
    cover: CoverBackground {
        Label {
            anchors.centerIn: parent
            text:  Qt.formatTime(clockWindow.date, "hh:mm")
            font.pixelSize: theme.fontSizeExtraLarge
        }
    }
}


